/*****************************************************************************
 *   i2c.h:  I2C functionality header file for NXP LPC29xx Family 
 *
 *   Copyright(C) 2009, NXP Semiconductor
 *   All rights reserved.
 *
 *   History
 *   2009.12.17  ver 1.00    Preliminary version, first Release
 *
 ****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 *****************************************************************************/

#ifndef __I2C_H 
#define __I2C_H

/* Demo settings */
#define I2CSLAVE_ADDR   0x90
#define I2CBUFSIZE      0x03
#define BITRATE_CONF    0xF0

/* */
#define MAX_TIMEOUT		0x00FFFFFF

/* I2C */
#define I2C0            0x00
#define I2C1            0x01

/* I2C modes */
#define I2CMASTER       0x01
#define I2CSLAVE        0x02

/* Read or Write */
#define WRITE           0
#define READ            1


/* I2C States */
#define I2C_IDLE			0
#define I2C_STARTED			1
#define I2C_RESTARTED		2
#define I2C_REPEATED_START	3
#define DATA_ACK			4
#define DATA_NACK			5

/* I2C Control clear Register bits */
#define I2C_AA		    (1<<2)  
#define I2C_SI      	(1<<3)
#define I2C_STO         (1<<4)
#define I2C_STA     	(1<<5)
#define I2C_I2EN	    (1<<6)

/* I2C function definition */
extern DWORD I2CInit      (BYTE select, BYTE mode);
extern DWORD I2C0start    (BYTE r_w);
extern void I2C0Handler   (void);
extern void I2C1Handler   (void);

#endif
